/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.tools;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import net.ftb.data.Map;
import net.ftb.data.Settings;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.dialogs.MapOverwriteDialog;
import net.ftb.log.Logger;
import net.ftb.util.DownloadUtils;
import net.ftb.util.FileUtils;
import net.ftb.util.OSUtils;
import net.ftb.util.TrackerUtils;

public class MapManager
extends JDialog {
    private JPanel contentPane;
    private double downloadedPerc;
    private final JProgressBar progressBar;
    private final JLabel label;
    public static boolean overwrite = false;
    private static String sep = File.separator;

    public MapManager(JFrame owner, Boolean model) {
        super((Frame)owner, (boolean)model);
        this.setResizable(false);
        this.setTitle("Downloading...");
        this.setDefaultCloseOperation(1);
        this.setBounds(100, 100, 313, 138);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(10, 63, 278, 22);
        this.contentPane.add(this.progressBar);
        JLabel lblDownloadingMap = new JLabel("<html><body><center>Downloading map...<br/>Please Wait</center></body></html>");
        lblDownloadingMap.setHorizontalAlignment(0);
        lblDownloadingMap.setBounds(0, 5, 313, 30);
        this.contentPane.add(lblDownloadingMap);
        this.label = new JLabel("");
        this.label.setHorizontalAlignment(0);
        this.label.setBounds(0, 42, 313, 14);
        this.contentPane.add(this.label);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent arg0) {
                MapManagerWorker worker = new MapManagerWorker(){

                    @Override
                    protected void done() {
                        MapManager.this.setVisible(false);
                        super.done();
                    }
                };
                worker.execute();
            }
        });
    }

    public static void cleanUp() {
        Map map = Map.getMap(LaunchFrame.getSelectedMapIndex());
        File tempFolder = new File(OSUtils.getCacheStorageLocation(), "Maps/".replace("/", sep) + map.getMapName() + sep);
        for (String file : tempFolder.list()) {
            if (file.equals(map.getLogoName()) || file.equals(map.getImageName()) || file.equalsIgnoreCase("version")) continue;
            try {
                FileUtils.delete(new File(tempFolder, file));
            }
            catch (IOException e) {
                Logger.logError(e.getMessage(), e);
            }
        }
    }

    private class MapManagerWorker
    extends SwingWorker<Boolean, Void> {
        private MapManagerWorker() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            Map map;
            String installPath = Settings.getSettings().getInstallPath();
            if (new File(installPath, (map = Map.getSelectedMap()).getSelectedCompatible() + "/minecraft/saves/" + map.getMapName()).exists()) {
                MapOverwriteDialog dialog = new MapOverwriteDialog();
                dialog.setVisible(true);
                if (overwrite) {
                    FileUtils.delete(new File(installPath, map.getSelectedCompatible() + "/minecraft/saves/" + map.getMapName()));
                } else {
                    Logger.logInfo("Canceled map installation.");
                    return false;
                }
            }
            this.downloadMap(map.getUrl(), map.getMapName());
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void downloadUrl(String filename, String urlString) throws MalformedURLException, IOException, NoSuchAlgorithmException {
            BufferedInputStream in = null;
            OutputStream fout = null;
            try {
                int count;
                URL url_ = new URL(urlString);
                in = new BufferedInputStream(url_.openStream());
                fout = new FileOutputStream(filename);
                byte[] data = new byte[1024];
                int amount = 0;
                int steps = 0;
                int mapSize = url_.openConnection().getContentLength();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MapManager.this.progressBar.setMaximum(10000);
                    }
                });
                while ((count = in.read(data, 0, 1024)) != -1) {
                    ((FileOutputStream)fout).write(data, 0, count);
                    MapManager.this.downloadedPerc = MapManager.this.downloadedPerc + (double)count * 1.0 / (double)mapSize * 100.0;
                    amount += count;
                    if (++steps <= 100) continue;
                    steps = 0;
                    final String txt = amount / 1024 + "Kb / " + mapSize / 1024 + "Kb";
                    final int perc = (int)MapManager.this.downloadedPerc * 100;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MapManager.this.progressBar.setValue(perc);
                            MapManager.this.label.setText(txt);
                        }
                    });
                }
            }
            catch (Exception e) {
                Logger.logError(e.getMessage(), e);
            }
            finally {
                in.close();
                fout.flush();
                ((FileOutputStream)fout).close();
            }
        }

        protected void downloadMap(String mapName, String dir) throws IOException, NoSuchAlgorithmException {
            Logger.logInfo("Downloading Map");
            String installPath = OSUtils.getCacheStorageLocation();
            Map map = Map.getSelectedMap();
            new File(installPath + "/" + "Maps/" + dir + "/").mkdirs();
            new File(installPath + "/" + "Maps/" + dir + "/" + mapName).createNewFile();
            this.downloadUrl(installPath + "/" + "Maps/" + dir + "/" + mapName, DownloadUtils.getCreeperhostLink("Maps/" + dir + "/" + map.getVersion().replace(".", "_") + "/" + mapName));
            FileUtils.extractZipTo(installPath + "/" + "Maps/" + dir + "/" + mapName, installPath + "/" + "Maps/" + dir);
            this.installMap(mapName, dir);
        }

        protected void installMap(String mapName, String dir) throws IOException {
            Logger.logInfo("Installing Map");
            String installPath = Settings.getSettings().getInstallPath();
            String tempPath = OSUtils.getCacheStorageLocation();
            Map map = Map.getSelectedMap();
            new File(installPath, map.getSelectedCompatible() + "/minecraft/saves/" + dir).mkdirs();
            FileUtils.copyFolder(new File(tempPath, "Maps/" + dir + "/" + dir), new File(installPath, map.getSelectedCompatible() + "/minecraft/saves/" + dir));
            FileUtils.copyFile(new File(tempPath, "Maps/" + dir + "/" + "version"), new File(installPath, map.getSelectedCompatible() + "/minecraft/saves/" + dir + "/version"));
            TrackerUtils.sendPageView(map.getName() + " Install", map.getName());
        }
    }
}

